<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

// 🌐 Obter a URL base dinamicamente
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http";
$host = $_SERVER['HTTP_HOST'];
$basePath = dirname($_SERVER['SCRIPT_NAME']);
$baseUrl = "$protocol://$host$basePath";

// 📂 Caminho do arquivo JSON de configuração
$jsonFile = __DIR__ . '/img/api.json';

// 🖼️🔼 Processar upload de background se o formulário foi enviado
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['background'])) {
    // 📥 Carregar configurações existentes
    $jsonData = file_exists($jsonFile) ? json_decode(file_get_contents($jsonFile), true) : [
        'logo' => '',
        'background' => ''
    ];

    $uploadDir = __DIR__ . '/img/';
    $response = ['success' => false, 'message' => '', 'newBgUrl' => ''];

    try {
        // 📁 Verificar se a pasta img existe, se não, criar
        if (!file_exists($uploadDir)) {
            mkdir($uploadDir, 0755, true);
        }

        // 🎲 Função para gerar nome aleatório de imagem
        function generateRandomImageName() {
            $chars = 'abcdefghijklmnopqrstuvwxyz0123456789';
            $result = '';
            for ($i = 0; $i < 8; $i++) {
                $result .= $chars[rand(0, strlen($chars) - 1)];
            }
            return 'bg-' . $result . '.jpg';
        }

        // 🖼️🔼 Processar background
        if (!empty($_FILES['background']['name'])) {
            // 🔍 Verificar se é uma imagem
            $check = getimagesize($_FILES['background']['tmp_name']);
            if($check === false) {
                throw new Exception('❌ O arquivo não é uma imagem válida');
            }

            $bgName = generateRandomImageName();
            $bgPath = $uploadDir . $bgName;
            
            if (move_uploaded_file($_FILES['background']['tmp_name'], $bgPath)) {
                $newBgUrl = $baseUrl . '/img/' . $bgName;
                $jsonData['background'] = $newBgUrl;
                $response['newBgUrl'] = $newBgUrl;
            } else {
                throw new Exception('❌ Falha ao fazer upload do background');
            }
        }
        
        // 💾 Salvar o JSON atualizado
        if (file_put_contents($jsonFile, json_encode($jsonData, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES))) {
            $response['success'] = true;
            $response['message'] = '✅ Background atualizado com sucesso!';
        } else {
            throw new Exception('❌ Falha ao salvar o arquivo JSON');
        }
    } catch (Exception $e) {
        $response['message'] = $e->getMessage();
    }

    // 📡 Retornar JSON para requisições AJAX
    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}

// 📖 Ler configurações atuais
$currentSettings = file_exists($jsonFile) ? json_decode(file_get_contents($jsonFile), true) : [
    'logo' => '',
    'background' => ''
];

$page_title = "🎨🌄 Painel de Background";
$page_content = '
<div class="container mt-5">
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h3 class="mb-0">🎨 Alterar Background</h3>
        </div>
        <div class="card-body">
            <form id="bgUploadForm" enctype="multipart/form-data" method="POST">
                <div class="mb-4">
                    <label for="bgUpload" class="form-label">📂 Selecione o novo background:</label>
                    <input type="file" class="form-control" name="background" id="bgUpload" accept="image/*" required>
                    <div class="form-text">📌 Formatos suportados: JPG, PNG. Tamanho recomendado: 1920x1080px</div>
                </div>
                
                <div class="mb-4">
                    <label class="form-label">👀 Pré-visualização:</label>
                    <div id="bgPreviewContainer" class="border p-3 text-center bg-light">
                        <img id="bgPreview" src="' . $currentSettings['background'] . '" class="img-fluid" style="max-height: 200px; max-width: 100%;">
                        <div id="noBgText" class="text-muted"' . (!empty($currentSettings['background']) ? ' style="display:none;"' : '') . '>🖼️ Nenhum background selecionado</div>
                    </div>
                </div>
                
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-upload me-2"></i>🔼 Atualizar Background
                </button>
                <div id="uploadStatus" class="mt-3"></div>
            </form>
            
            <div class="mt-5">
                <h5>ℹ️ Informações Atuais:</h5>
                <div class="alert alert-info">
                    <p><strong>🌄 Background atual:</strong> <code>' . $currentSettings['background'] . '</code></p>
                    <p><strong>🌐 Domínio detectado:</strong> ' . $host . '</p>
                    <p><strong>📂 Subpasta detectada:</strong> ' . $basePath . '</p>
                    <p><strong>🔗 URL completa:</strong> ' . $baseUrl . '</p>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
#bgPreviewContainer {
    background-image: linear-gradient(45deg, #eee 25%, transparent 25%), 
                     linear-gradient(-45deg, #eee 25%, transparent 25%), 
                     linear-gradient(45deg, transparent 75%, #eee 75%), 
                     linear-gradient(-45deg, transparent 75%, #eee 75%);
    background-size: 20px 20px;
    background-position: 0 0, 0 10px, 10px -10px, -10px 0px;
}
</style>

<script>
// 👁️ Preview da imagem antes do upload
document.getElementById("bgUpload").addEventListener("change", function(e) {
    const file = e.target.files[0];
    const preview = document.getElementById("bgPreview");
    const noBgText = document.getElementById("noBgText");
    
    if (file) {
        const reader = new FileReader();
        
        reader.onload = function(e) {
            preview.src = e.target.result;
            preview.style.display = "block";
            noBgText.style.display = "none";
        }
        
        reader.readAsDataURL(file);
    } else {
        preview.src = "";
        preview.style.display = "none";
        noBgText.style.display = "block";
    }
});

// 🚀 Envio do formulário via AJAX
document.getElementById("bgUploadForm").addEventListener("submit", function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const statusElement = document.getElementById("uploadStatus");
    const submitBtn = this.querySelector("button[type=\'submit\']");
    const preview = document.getElementById("bgPreview");
    
    // ⏳ Mostrar loading no botão
    submitBtn.disabled = true;
    submitBtn.innerHTML = \'<i class="fas fa-spinner fa-spin me-2"></i>⏳ Atualizando...\';
    
    fetch("", {
        method: "POST",
        body: formData,
        headers: {
            "X-Requested-With": "XMLHttpRequest"
        }
    })
    .then(response => {
        if (!response.ok) throw new Error("🌐 Erro na rede");
        return response.json();
    })
    .then(data => {
        if (data.success) {
            statusElement.innerHTML = `
                <div class="alert alert-success d-flex align-items-center">
                    <i class="fas fa-check-circle me-2"></i>
                    <div>${data.message}</div>
                </div>
            `;
            
            // Atualizar preview com a nova imagem
            if (data.newBgUrl) {
                preview.src = data.newBgUrl;
            }
            
            // Atualizar após 2 segundos para garantir sincronização
            setTimeout(() => {
                location.reload();
            }, 2000);
        } else {
            statusElement.innerHTML = `
                <div class="alert alert-danger d-flex align-items-center">
                    <i class="fas fa-exclamation-circle me-2"></i>
                    <div>❌ ${data.message}</div>
                </div>
            `;
        }
    })
    .catch(error => {
        statusElement.innerHTML = `
            <div class="alert alert-danger d-flex align-items-center">
                <i class="fas fa-exclamation-circle me-2"></i>
                <div>❌ Erro: ${error.message}</div>
            </div>
        `;
    })
    .finally(() => {
        submitBtn.disabled = false;
        submitBtn.innerHTML = \'<i class="fas fa-upload me-2"></i>🔼 Atualizar Background\';
    });
});
</script>
';

include 'includes/layout.php';
?>