<?php

$json_file = __DIR__ . '/sports.json';

$encoded_link = '';

if (file_exists($json_file)) {
    $json = json_decode(file_get_contents($json_file), true);
    $encoded_link = $json['encoded_link'] ?? '';
}

$decoded_link = $encoded_link ? base64_decode($encoded_link) : '';

?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Sport Webview</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body {
            background: #000;
            margin: 0;
            padding: 0;
            overflow: hidden;
        }
        iframe {
            width: 100%;
            height: 100vh;
            border: none;
        }
        .warning {
            color: #fff;
            text-align: center;
            margin-top: 40px;
            font-size: 18px;
        }
        .warning a {
            color: #00f;
        }
    </style>
</head>
<body>

<?php if (!empty($decoded_link)): ?>

    <!-- ✅ FORMA CORRETA -->
    <iframe src="<?php echo htmlspecialchars($decoded_link); ?>" allowfullscreen></iframe>

<?php else: ?>

    <div class="warning">
        Nenhum link foi configurado no painel.
    </div>

<?php endif; ?>

</body>
</html>
