<?php
header('Content-Type: application/json');

// Carrega configurações
$configFile = __DIR__ . '/config.json';
$config = file_exists($configFile)
    ? json_decode(file_get_contents($configFile), true)
    : [];

if (empty($_GET['code'])) {
    echo json_encode([
        'status' => 'pending',
        'expiration_date' => null
    ]);
    exit;
}

try {
    $code = trim($_GET['code']);
    $id_dispositivo = $_GET['id_dispositivo'] ?? null;

    // Conexão SQLite
    $dbPath = __DIR__ . '/max.db';
    $db = new PDO('sqlite:' . $dbPath);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // 🔍 Busca código
    $stmt = $db->prepare(
        "SELECT status, expiration_date, id_dispositivo 
         FROM activations 
         WHERE code = :code 
         LIMIT 1"
    );
    $stmt->execute([':code' => $code]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    /**
     * =================================================
     * ✔ CÓDIGO JÁ EXISTE → SEMPRE RESPEITA O BANCO
     * =================================================
     */
    if ($row) {

        $status = strtolower(trim($row['status']));
        $expiration = $row['expiration_date'];

        // ⏰ Verifica expiração
        if (!empty($expiration)) {
            $today = new DateTime('today');
            $exp = new DateTime($expiration);
            $exp->modify('+1 day');

            if ($today > $exp) {
                $status = 'expired';

                // Atualiza banco se expirou
                $upd = $db->prepare(
                    "UPDATE activations SET status = 'expired' WHERE code = :code"
                );
                $upd->execute([':code' => $code]);
            }
        }

        echo json_encode([
            'status' => $status,
            'expiration_date' => $expiration
        ]);
        exit;
    }

    /**
     * =================================================
     * ✔ PRIMEIRO ACESSO → REGISTRO AUTOMÁTICO
     * =================================================
     */

    // Dias padrão
    $days = isset($config['default_expiration_days']) && is_numeric($config['default_expiration_days'])
        ? (int)$config['default_expiration_days']
        : 7;

    $expiration_date = date('Y-m-d', strtotime("+{$days} days"));
    $status = strtolower($config['default_status'] ?? 'pending');

    $user = 'Teste Automático';
    $registration_date = date('Y-m-d H:i:s');

    $insert = $db->prepare(
        "INSERT INTO activations 
        (code, status, expiration_date, user, id_dispositivo, registration_date)
        VALUES 
        (:code, :status, :expiration_date, :user, :id_dispositivo, :registration_date)"
    );

    $insert->execute([
        ':code' => $code,
        ':status' => $status,
        ':expiration_date' => $expiration_date,
        ':user' => $user,
        ':id_dispositivo' => $id_dispositivo,
        ':registration_date' => $registration_date
    ]);

    echo json_encode([
        'status' => $status,
        'expiration_date' => $expiration_date
    ]);

} catch (Throwable $e) {
    error_log('[ACTIVATION ERROR] ' . $e->getMessage());

    echo json_encode([
        'status' => 'pending',
        'expiration_date' => null
    ]);
}
