<?php
// launcher/api/app_info.php (dinâmico: lê app_info.json)
header('Content-Type: application/json; charset=utf-8');

$jsonFile = __DIR__ . '/app_info.json';

if (!file_exists($jsonFile)) {
    // fallback: valores padrão
    $response = [
        "latest_version" => 1,
        "apk_url" => "",
        "force_update" => false
    ];
    http_response_code(200);
    echo json_encode($response, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
    exit;
}

$content = file_get_contents($jsonFile);
$decoded = json_decode($content, true);

if (!is_array($decoded)) {
    http_response_code(500);
    echo json_encode(["error" => "Invalid app_info.json"]);
    exit;
}

// Normaliza valores para saída segura
$response = [
    "latest_version" => isset($decoded['latest_version']) ? (int)$decoded['latest_version'] : 1,
    "apk_url" => isset($decoded['apk_url']) ? $decoded['apk_url'] : "",
    "force_update" => isset($decoded['force_update']) ? (bool)$decoded['force_update'] : false
];

http_response_code(200);
echo json_encode($response, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
exit;
